PROGRAM Startup_Sequence
VAR
iURV, i, iTemp											: INT ;
j														: UINT ;
k														: USINT ;
rTemp													: REAL ;
Display_Registers_Writing 								: ModbusRegistersFB ;
Check_New_Value_FB										: FB_limits_verification ;
END_VAR
IF StartupCounter<3 THEN
	iURV := SetInputTypeF ( 1, InputType:=0); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 2, InputType:=0);			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 3, InputType:=1); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 4, InputType:=1); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 5, InputType:=0); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 6, InputType:=0); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 7, InputType:=3); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 8, InputType:=3); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF ( 9, InputType:=4); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF (10, InputType:=4); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF (11, InputType:=3); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	iURV := SetInputTypeF (12, InputType:=3); 			(* 0=resistance filtered, 1=Voltage, 2=resistance unfiltered, 3=NO-DI, 4=NC-DI, 5=impulse > 25 msec *)
	
	iURV := SetAnalogOutputF (1, value:=0.0);			(* set AO outputs to "0" at startup *)
	iURV := SetAnalogOutputF (2, value:=0.0);			(* set AO outputs to "0" at startup *)
	iURV := SetAnalogOutputF (3, value:=0.0);			(* set AO outputs to "0" at startup *)
	iURV := SetAnalogOutputF (4, value:=0.0);			(* set AO outputs to "0" at startup *)
	iURV := SetAnalogOutputF (5, value:=0.0);			(* set AO outputs to "0" at startup *)
	iURV := SetAnalogOutputF (6, value:=0.0);			(* set AO outputs to "0" at startup *)
	iURV := SetAnalogOutputF (7, value:=0.0);			(* set AO outputs to "0" at startup *)
	iURV := SetAnalogOutputF (8, value:=0.0);			(* set AO outputs to "0" at startup *)
	
	iURV := SetDigitalOutputF (1, value:=0);			(* set DO outputs off at startup *)
	iURV := SetDigitalOutputF (2, value:=0);			(* set DO outputs off at startup *)
	iURV := SetDigitalOutputF (3, value:=0);			(* set DO outputs off at startup *)
	iURV := SetDigitalOutputF (4, value:=0);			(* set DO outputs off at startup *)

	rTemp := GetFirmwareVersionF (VersionType:=1) ;		(* firmware version *)
	ProgramValues[1] 	:= rTemp * 100.0 ;
	rTemp := GetFirmwareVersionF (VersionType:=2) ; 	(* bootloader version *)
	ProgramValues[2] 	:= rTemp * 100.0 ;
	iURV  := SetNameF ('Air Handling Unit v0.10') ;
	ProgramValues[35]	:= 100.0 ;						(* software version # x100 *) 
	
	Display_Registers_Writing.SlaveAddress 	:= DisplayAddress ; 
	Display_Registers_Writing.StartRegister := 3040 ; 
	Display_Registers_Writing.RegisterCount := 8 ; 
	Display_Registers_Writing.RegisterType 	:= 3 ; 
	Display_Registers_Writing.TimeOut 		:= 300 ; 
	Display_Registers_Writing.PollInterval 	:= 500 ; 								
	Display_Registers_Writing.REG0 			:= 0 ;									(* REG 3040 - Disable Click Sound *)
	Display_Registers_Writing.REG1 			:= 1 ;									(* REG 3041 - Enable Finger Mode *)
	Display_Registers_Writing.REG3 			:= 1 ;									(* REG 3043 - Disable Settings Page Access through long press *)
	Display_Registers_Writing.REG7 			:= 1 ;									(* REG 3047 - Disable Calibration Page Access through long press *)
	Display_Registers_Writing.Send 			:= 1 ; 									(* start writing to the display *)
	
	Display_Registers_Writing() ;
	StartupCounter := StartupCounter + 1 ;
ELSIF StartupCounter=3 THEN															
	FOR i:=36 TO 47 BY 1 DO															(* go through all registers the user can edit *)
		j := INT_TO_UINT(i) ;
		iTemp := WORD_TO_INT ( GetRegisterF(j) ) ;
		ProgramValues[i] := INT_TO_REAL (iTemp) ;									(* and load them into the program *)	
		
		IF ProgramValues[40]=0.0 THEN												(* module seems to be vanilla *)
			ProgramValues[i] := F_Factory_Default_Value(PointNR:=i) ;				(* load factory default values *)
		ELSE																		(* module has some values; this is probably a reboot *)
			Check_New_Value_FB (PointNR:=i) ;										(* verify if loaded values from registers are within limits *)
			IF Check_New_Value_FB.PointValue_Changed THEN							(* saved register value is outside of limits *)
				ProgramValues[i] := F_Factory_Default_Value(PointNR:=i) ;			(* load the factory default value *)
			END_IF ;
		END_IF ;
	END_FOR ;
	
	Display_Registers_Writing() ;
	StartupCounter := StartupCounter + 1 ;
ELSIF StartupCounter>3 AND StartupCounter<6 THEN
	Display_Registers_Writing() ;
	StartupCounter := StartupCounter + 1 ;
ELSIF StartupCounter=6 THEN						
	Display_Registers_Writing() ;
	StartupCounter := StartupCounter + 1 ;
	module_ready := TRUE ;
ELSIF StartupCounter>6 AND StartupCounter<99 THEN
	Display_Registers_Writing() ;
	StartupCounter := StartupCounter + 1 ;
ELSIF StartupCounter=99 THEN														(* display special register should now definitely be set *)
	Display_Registers_Writing.Send := 10 ; 											(* stop communicating with the display special registers *)
	Display_Registers_Writing() ;
	StartupCounter := StartupCounter + 1 ;
END_IF ;
END_PROGRAM